//
//  GeometryGamesContactView.swift
//
//  Created by Jeff on 16/12/20.
//  Copyright © 2020 Jeff Weeks. All rights reserved.
//

import SwiftUI


struct GeometryGamesHelpMenuContactItemLabel: View {

	var body: some View {

		Label(
			Bundle.main.localizedString(
				forKey: "Contact",
				value: nil,
				table: "GeometryGamesLocalizable"
			),
			systemImage: "square.and.pencil"
		)
	}
}


struct GeometryGamesContactView: View {

	var body: some View {
	
		let theQuestionsPreString = Bundle.main.localizedString(
			forKey: "Contact-QuestionsPre",
			value: nil,
			table: "GeometryGamesLocalizable")

		let theQuestionsContactString = Bundle.main.localizedString(
			forKey: "Contact-Questions",
			value: nil,
			table: "GeometryGamesLocalizable")

		let theQuestionsPostString = Bundle.main.localizedString(
			forKey: "Contact-QuestionsPost",
			value: nil,
			table: "GeometryGamesLocalizable")

		let theMoreAppsPreLine = Bundle.main.localizedString(
			forKey: "Contact-MoreAppsPre",
			value: nil,
			table: "GeometryGamesLocalizable")

		let theMoreAppsPostLine = Bundle.main.localizedString(
			forKey: "Contact-MoreAppsPost",
			value: nil,
			table: "GeometryGamesLocalizable")

		VStack() {
		
			if theQuestionsPreString.count > 0 {
				Text(theQuestionsPreString)
					.font(.body)
					.multilineTextAlignment(.center)
			}
		
			if let theContactURL = URL(string: "http://www.geometrygames.org/contact.html") {
				Link(theQuestionsContactString, destination: theContactURL)
					.font(.title3)
					.multilineTextAlignment(.center)
			} else {	//	should never occur
				Text("http://www.geometrygames.org/contact.html")
					.font(.title3)
			}
			
			if theQuestionsPostString.count > 0 {
				Text(theQuestionsPostString)
					.font(.body)
					.multilineTextAlignment(.center)
			}
		
			Spacer(minLength: 16)

			Text(theMoreAppsPreLine)
				.font(.body)
				.multilineTextAlignment(.center)

			if let thGeometryGamesURL = URL(string: "http://www.geometrygames.org") {
				Link("www.geometrygames.org", destination: thGeometryGamesURL)
					.font(.body)
			} else {	//	should never occur
				Text(verbatim: "www.geometrygames.org")
					.font(.body)
			}
			
			if theMoreAppsPostLine.count > 0 {
				Text(theMoreAppsPostLine)
					.font(.body)
					.multilineTextAlignment(.center)
			}
		}
		.fixedSize()
		.padding(geometryGamesPanelPadding)
		.background(Color(.displayP3, red: 0.875, green: 0.875, blue: 0.875, opacity: 1.0))
		.cornerRadius(geometryGamesCornerRadius)
	}
}


struct GeometryGamesContactView_Previews: PreviewProvider {
	static var previews: some View {
		GeometryGamesContactView()
	}
}
